% data: 2017/03/26
% article title: A General Framework for Shiftable Position-based Dual-image Reversible Data Hiding, Authors: H Yao et al.
% Email: hyao@usst.edu.cn
% Published at EURASIP Journal on Image and Video Processing


function  [PSNR1,PSNR2] = newdualRDH(I,Message,embedrate);

I=double(I);
[row,col]=size(I);
% Y1 and Y2 are modified dual-image
Y1=I;  
Y2=I;
Embed_rate=embedrate;
Messagelength=round(Embed_rate*row*col*2);

% step 1: seek the optimal n
Nset=[3:2:257];
Tset=floor(log2(Nset));
alphaNset=0.5*(Tset.*(2.^(Tset+1)-Nset)./(2.^Tset)+(Tset+1).*(Nset-2.^Tset)./(2.^Tset));
Knset=Nset; 
for i=1:length(Nset) 
% underflow pixels
 a=sum(sum(I<ceil((Nset(i)-1)/4)));
 % overlow pixels
 b=sum(sum(I>(255-floor((Nset(i)-1)/4))));
 Knset(i)=a+b;
end

newalphaNset=(row*col-Knset).*alphaNset/(row*col);

for i=1:length(Nset)
    n=Nset(i);
    if newalphaNset(i)>=Embed_rate
        break
    end
end
      t=Tset(i);
      underflow_threshold=ceil((Nset(i)-1)/4);
      overflow_threshold=(255-floor((Nset(i)-1)/4));
   
% step2: generate the code table
      capacity=0;
 for i=1:row
    for j=1:col
    xi=I(i,j);    
    if (xi<underflow_threshold) || (xi>overflow_threshold)
            yi1=xi;
            yi2=xi;
            capacity=capacity;
    else  
     d=0;
      m=Message(capacity+1:capacity+t);
       for z=1:t
            d=d+m(t-z+1)*2^(z-1);
       end
      if d<=(2^(t+1)-n-1)
          P=d+1;
          capacity=capacity+t;
      else capacity=capacity+t+1;
          P=(2^(t+1)-n)+2*(d-2^(t+1)+n)+Message(capacity)+1;
      end
     % step3: modify the cover pixel pair
        if mod(P,2)==1
            yi1=xi+floor((P-1)/4);
            yi2=xi-ceil((P-1)/4);
        else
            yi1=xi-ceil(P/4);
            yi2=xi+floor(P/4);
        end
        end
        Y1(i,j)=yi1;
        Y2(i,j)=yi2;
        if capacity>=Messagelength
            break
        break
        end
    end
end 

PSNR1=impsnr(I,Y1);
PSNR2=impsnr(I,Y2);
PSNRAVG=mean([PSNR1,PSNR2]);
